IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='RC_CLI_CONV_RC_CLI_LOG_API') 
BEGIN
	CREATE TABLE [DBO].[RC_CLI_CONV_RC_CLI_LOG_API](
		[CD_CTR] [INT] IDENTITY(1,1) NOT NULL,
		[CD_EMP] [INT] NOT NULL,
		[CD_CONV] [INT] NOT NULL,
		[CD_CLI] [INT] NULL,
		[IDENTIFICACAO_CLIENTE] [VARCHAR](100) NULL, -- INFORMAR NO CAMPO TEXTO SE  MATRCULA, CPF OU QQ OUTRO QUE VENHA A SURGIR
		[DT_CAD] [DATETIME] NOT NULL,
		[RETORNO_STATUS_CLIENTE] [VARCHAR](255), -- ATIVO / INATIVO / BLOQUEADO / LIBERADO / EXCEO: CPF INVLIDO
		[ID_RETORNO_API] [VARCHAR] (100),
		[STATUS_CODE] [INT],  -- CDIGO PADRO DE RETORNO DE REQUISIO
		[JSON_ENVIO] [VARCHAR](MAX), -- COMANDO FEITO NO MOMENTO DA REQUISIO
		[JSON_RETORNO] [VARCHAR](MAX), -- CDIGO RETORNADO PELA API

	CONSTRAINT [PK_RC_CLI_CONV_RC_CLI_LOG_API] PRIMARY KEY CLUSTERED 
	(
		[CD_CTR] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [DBO].[RC_CLI_CONV_RC_CLI_LOG_API] ADD  CONSTRAINT [DF_RC_CLI_CONV_RC_CLI_LOG_API_DT_CAD]  DEFAULT (GETDATE()) FOR [DT_CAD]

END